<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

// Initialize response array
$response = array("error" => false, "message" => "", "data" => array());

try {
    // Check if agentCredentials is posted and decode the JSON data
    if (!isset($_POST['agentCredentials'])) {
        throw new Exception("agentCredentials are required.");
    }

    // Decode the JSON data from agentCredentials
    $credentials = json_decode($_POST['agentCredentials'], true);
    
    // Check if data is valid and contains email and password
    if (empty($credentials) || !isset($credentials[0]['email']) || !isset($credentials[0]['password'])) {
        throw new Exception("Invalid data format or missing email and password.");
    }

    // Sanitize and assign email and password from the decoded JSON
    $email = mysqli_real_escape_string($connect, $credentials[0]['email']);
    $password = mysqli_real_escape_string($connect, $credentials[0]['password']);

    // Query to retrieve agent data based on email and password
    $sql = "SELECT * FROM agents WHERE email = '$email' AND passsword = '$password'";
    $statement = $connect->query($sql);

    // Check for query execution error
    if (!$statement) {
        throw new Exception("Error executing query: " . $connect->error);
    }

    // Fetch agent data
    if ($statement->num_rows > 0) {
        $response['message'] = "Agent found.";
        while ($row = $statement->fetch_assoc()) {
            array_push($response["data"], $row);
        }
    } else {
        $response["error"] = true;
        $response["message"] = "No agent found with the provided email and password.";
    }
} catch (Exception $e) {
    // Handle any exceptions and set error in the response
    $response["error"] = true;
    $response["message"] = $e->getMessage();
}

// Output the JSON response
echo json_encode($response);

// Close the database connection
$connect->close();
?>
