<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

// Initialize response array
$response = array(
    "error" => false,
    "data" => array(
        "today" => array(
            "Deposit" => array("count" => 0, "amount" => 0),
            "Withdraw" => array("count" => 0, "amount" => 0),
            "New Account" => array("count" => 0, "amount" => 0),
            "Loan Pay" => array("count" => 0, "amount" => 0),
            "New loan ACC" => array("count" => 0, "amount" => 0),
            "total" => array("count" => 0, "amount" => 0)
        ),
        "this_week" => array(
            "Deposit" => array("count" => 0, "amount" => 0),
            "Withdraw" => array("count" => 0, "amount" => 0),
            "New Account" => array("count" => 0, "amount" => 0),
            "Loan Pay" => array("count" => 0, "amount" => 0),
            "New loan ACC" => array("count" => 0, "amount" => 0),
            "total" => array("count" => 0, "amount" => 0)
        ),
        "this_month" => array(
            "Deposit" => array("count" => 0, "amount" => 0),
            "Withdraw" => array("count" => 0, "amount" => 0),
            "New Account" => array("count" => 0, "amount" => 0),
            "Loan Pay" => array("count" => 0, "amount" => 0),
            "New loan ACC" => array("count" => 0, "amount" => 0),
            "total" => array("count" => 0, "amount" => 0)
        )
    ),
    "message" => "Agent dashboard data retrieved successfully."
);

// Get the posted email
$agentEmail = isset($_POST['agentEmail']) ? mysqli_real_escape_string($connect, $_POST['agentEmail']) : null;

if (empty($agentEmail)) {
    $response["error"] = true;
    $response["message"] = "Agent email is required.";
    echo json_encode($response);
    exit;
}

// Define time periods
$todayStart = date('Y-m-d'); // Only date part
$thisWeekStart = date('Y-m-d', strtotime('monday this week'));
$thisMonthStart = date('Y-m-01');

// Define transaction types
$transactionTypes = ["Deposit", "Withdraw", "New Account", "Loan Pay", "New loan ACC"];

// Fetch data for each period
$periods = [
    "today" => $todayStart,
    "this_week" => $thisWeekStart,
    "this_month" => $thisMonthStart
];

foreach ($periods as $periodKey => $periodStart) {
    $totalCount = 0;
    $totalAmount = 0.0;

    foreach ($transactionTypes as $type) {
        // Convert 'dateTime' VARCHAR to DATE for comparison
        $query = "
            SELECT COUNT(*) AS count, COALESCE(SUM(amount_Diposited), 0) AS amount
            FROM deposits
            WHERE operatingAgent = '$agentEmail'
            AND transaction = '$type'
            AND DATE(STR_TO_DATE(dateTime, '%Y-%m-%d %H:%i:%s')) >= '$periodStart'
            AND DATE(STR_TO_DATE(dateTime, '%Y-%m-%d %H:%i:%s')) <= DATE(NOW())
        ";

        $result = mysqli_query($connect, $query);

        if ($result) {
            $row = mysqli_fetch_assoc($result);

            // Set count and amount for the transaction type in the specific period
            $count = (int) ($row['count'] ?? 0);
            $amount = (float) ($row['amount'] ?? 0);

            $response["data"][$periodKey][$type]["count"] = $count;
            $response["data"][$periodKey][$type]["amount"] = $amount;

            // Update totals for the period
            $totalCount += $count;
            $totalAmount += $amount;
        } else {
            $response["error"] = true;
            $response["message"] = "Error retrieving data: " . mysqli_error($connect);
            echo json_encode($response);
            exit;
        }
    }

    // Set total count and amount for the period
    $response["data"][$periodKey]["total"]["count"] = $totalCount;
    $response["data"][$periodKey]["total"]["amount"] = $totalAmount;
}

// Output JSON response
echo json_encode($response);

// Close the database connection
mysqli_close($connect);
?>
