<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

// Initialize response array
$response = array("error" => false, "data" => array(), "message" => "");

// Retrieve and sanitize posted email
$agentEmail = isset($_POST['agentEmail']) ? mysqli_real_escape_string($connect, $_POST['agentEmail']) : null;
if (empty($agentEmail)) {
    $response["error"] = true;
    $response["message"] = "Agent email is required.";
    echo json_encode($response);
    exit;
}

// Define time periods
$todayStart = date('Y-m-d 00:00:00');
$thisWeekStart = date('Y-m-d 00:00:00', strtotime('monday this week'));
$thisMonthStart = date('Y-m-01 00:00:00');

// Initialize period data arrays
$periods = [
    "today" => $todayStart,
    "this_week" => $thisWeekStart,
    "this_month" => $thisMonthStart
];

// Transaction types to retrieve
$transactionTypes = ["Deposit", "Withdraw", "New Account", "Loan Pay", "New loan ACC"];

// Prepare data structure
$dashboardData = [
    "today" => [],
    "this_week" => [],
    "this_month" => []
];

// Loop through each period to get data
foreach ($periods as $periodKey => $periodStart) {
    $totalCount = 0;
    $totalAmount = 0.0;

    foreach ($transactionTypes as $type) {
        // Query to count transactions and sum amounts for each transaction type within the time period
        $query = "
            SELECT COUNT(*) as count, COALESCE(SUM(amount_Diposited), 0) as amount
            FROM deposits
            WHERE operatingAgent = '$agentEmail' 
            AND transaction = '$type'
            AND dateTime >= '$periodStart'
            AND dateTime <= NOW()
        ";

        $result = mysqli_query($connect, $query);
        if ($result) {
            $row = mysqli_fetch_assoc($result);

            // Set default values to 0 if no results found
            $count = (int)($row['count'] ?? 0);
            $amount = (float)($row['amount'] ?? 0.00);

            // Store transaction data by type
            $dashboardData[$periodKey][$type] = [
                "count" => $count,
                "amount" => $amount
            ];

            // Add to period totals
            $totalCount += $count;
            $totalAmount += $amount;
        } else {
            $response["error"] = true;
            $response["message"] = "Error retrieving data: " . mysqli_error($connect);
            echo json_encode($response);
            exit;
        }
    }

    // Store total data for the period
    $dashboardData[$periodKey]["total"] = [
        "count" => $totalCount,
        "amount" => $totalAmount
    ];
}

// Set response data
$response["data"] = $dashboardData;
$response["message"] = "Agent dashboard data retrieved successfully.";

// Output the JSON response
echo json_encode($response);

// Close database connection
$connect->close();
?>
