<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

// Initialize response array
$response = array("error" => false, "message" => "");

try {
    // Check if loanAccNumber is posted
    if (!isset($_POST['loanAcc'])) {
        throw new Exception("Loan account number (loanAcc) is required.");
    }

    // Sanitize and assign loan account number
    $loanAccNumber = mysqli_real_escape_string($connect, $_POST['loanAcc']);

    // Query to delete the loan record based on loan account number
    $sql = "DELETE FROM loans WHERE loanAccNumber = '$loanAccNumber'";
    $statement = $connect->query($sql);

    // Check if the query was executed successfully
    if (!$statement) {
        throw new Exception("Error executing query: " . $connect->error);
    }

    // Check if any rows were affected by the deletion
    if ($connect->affected_rows > 0) {
        $response["message"] = "Loan record deleted successfully.";
    } else {
        $response["error"] = true;
        $response["message"] = "No loan record found with the provided loan account number.";
    }
} catch (Exception $e) {
    // Handle any exceptions and set error in the response
    $response["error"] = true;
    $response["message"] = $e->getMessage();
}

// Output the JSON response
echo json_encode($response);

// Close the database connection
$connect->close();
?>
