<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

// Initialize response array
$response = array("error" => false, "message" => "");

// Check if receipt_No is provided in the POST data
if (!isset($_POST['receipt_No'])) {
    $response["error"] = true;
    $response["message"] = "Receipt number is required.";
    echo json_encode($response);
    exit;
}

// Sanitize and assign the receipt number from POST data
$receipt_No = mysqli_real_escape_string($connect, $_POST['receipt_No']);

// Begin a transaction to ensure both deletions succeed or fail together
mysqli_begin_transaction($connect);

try {
    // Delete from deposits table
    $queryDeposits = "DELETE FROM deposits WHERE receipt_No = '$receipt_No'";
    $resultDeposits = mysqli_query($connect, $queryDeposits);

    // Check if deletion was successful in deposits
    if (!$resultDeposits || mysqli_affected_rows($connect) === 0) {
        throw new Exception("Error deleting from deposits or receipt not found.");
    }

    // Commit the transaction
    mysqli_commit($connect);
    $response["message"] = "Transaction deleted successfully.";

} catch (Exception $e) {
    // Roll back the transaction on any error
    mysqli_rollback($connect);
    $response["error"] = true;
    $response["message"] = $e->getMessage();
}

// Output the JSON response
echo json_encode($response);

// Close the database connection
$connect->close();
?>
