<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

$response = array("error" => false, "message" => "Dashboard data retrieved successfully", "data" => array());

try {
    // Total number of agents
    $agentCountResult = mysqli_query($connect, "SELECT COUNT(*) AS total_agents FROM agents");
    $totalAgents = mysqli_fetch_assoc($agentCountResult)['total_agents'] ?? 0;
    
    // Total active agents
    $activeAgentCountResult = mysqli_query($connect, "SELECT COUNT(*) AS total_active_agents FROM agents WHERE account_type = 'active'");
    $totalActiveAgents = mysqli_fetch_assoc($activeAgentCountResult)['total_active_agents'] ?? 0;
    
    // Total number of customers
    $customerCountResult = mysqli_query($connect, "SELECT COUNT(*) AS total_customers FROM customer_data");
    $totalCustomers = mysqli_fetch_assoc($customerCountResult)['total_customers'] ?? 0;
    
    // Gender breakdown for customers
    $genderBreakdownResult = mysqli_query($connect, "SELECT gender, COUNT(*) AS count FROM customer_data GROUP BY gender");
    $genderBreakdown = array("Male" => 0, "Female" => 0);
    while ($row = mysqli_fetch_assoc($genderBreakdownResult)) {
        $genderBreakdown[$row['gender']] = (int) ($row['count'] ?? 0);
    }
    
    // Total and average account balance
    $balanceResult = mysqli_query($connect, "SELECT SUM(ccount_balance) AS total_balance, AVG(ccount_balance) AS avg_balance FROM customer_data");
    $balanceData = mysqli_fetch_assoc($balanceResult);
    $totalBalance = (int) ($balanceData['total_balance'] ?? 0);
    $avgBalance = (int) ($balanceData['avg_balance'] ?? 0);
    
    // Charges by transaction type
    $chargesByTransactionResult = mysqli_query($connect, "SELECT transaction, SUM(charges) AS total_charges FROM deposits GROUP BY transaction");
    $chargesByTransaction = array("Deposit" => 0, "Withdraw" => 0, "New Account" => 0, "New Loan" => 0);
    while ($row = mysqli_fetch_assoc($chargesByTransactionResult)) {
        $chargesByTransaction[$row['transaction']] = (int) ($row['total_charges'] ?? 0);
    }
    
    // Transactions of today
    $todayResult = mysqli_query($connect, "
        SELECT COUNT(*) AS count_today, SUM(amount_Diposited) AS total_today 
        FROM deposits 
        WHERE DATE(dateTime) = CURDATE()");
    $todayData = mysqli_fetch_assoc($todayResult);
    $todayCount = (int) ($todayData['count_today'] ?? 0);
    $todayTotal = (int) ($todayData['total_today'] ?? 0);
    
    // Transactions of this week
    $weekResult = mysqli_query($connect, "
        SELECT COUNT(*) AS count_week, SUM(amount_Diposited) AS total_week 
        FROM deposits 
        WHERE YEARWEEK(dateTime, 1) = YEARWEEK(CURDATE(), 1)");
    $weekData = mysqli_fetch_assoc($weekResult);
    $weekCount = (int) ($weekData['count_week'] ?? 0);
    $weekTotal = (int) ($weekData['total_week'] ?? 0);
    
    // Transactions of this month
    $monthResult = mysqli_query($connect, "
        SELECT COUNT(*) AS count_month, SUM(amount_Diposited) AS total_month 
        FROM deposits 
        WHERE MONTH(dateTime) = MONTH(CURDATE()) AND YEAR(dateTime) = YEAR(CURDATE())");
    $monthData = mysqli_fetch_assoc($monthResult);
    $monthCount = (int) ($monthData['count_month'] ?? 0);
    $monthTotal = (int) ($monthData['total_month'] ?? 0);

    // Transaction comparison (New Account vs Deposit vs Withdraw vs New Loans) with total charges for each
    $transactionComparisonResult = mysqli_query($connect, "
        SELECT transaction, COUNT(*) AS transaction_count, SUM(charges) AS total_charges 
        FROM deposits 
        WHERE transaction IN ('New Account', 'Deposit', 'Withdraw', 'New Loan') 
        GROUP BY transaction");
    
    $transactionComparison = array(
        "New Account" => array("count" => 0, "total_charges" => 0),
        "Deposit" => array("count" => 0, "total_charges" => 0),
        "Withdraw" => array("count" => 0, "total_charges" => 0),
        "New Loan" => array("count" => 0, "total_charges" => 0)
    );
    
    while ($row = mysqli_fetch_assoc($transactionComparisonResult)) {
        $transactionComparison[$row['transaction']] = array(
            "count" => (int) ($row['transaction_count'] ?? 0),
            "total_charges" => (int) ($row['total_charges'] ?? 0)
        );
    }

    // Preparing the response
    $response['data'] = array(
        "total_agents" => $totalAgents,
        "total_active_agents" => $totalActiveAgents,
        "total_customers" => $totalCustomers,
        "gender_breakdown" => $genderBreakdown,
        "total_balance" => $totalBalance,
        "average_balance" => $avgBalance,
        "charges_by_transaction" => $chargesByTransaction,
        "transactions" => array(
            "today" => array(
                "count" => $todayCount,
                "total" => $todayTotal
            ),
            "this_week" => array(
                "count" => $weekCount,
                "total" => $weekTotal
            ),
            "this_month" => array(
                "count" => $monthCount,
                "total" => $monthTotal
            )
        ),
        "transaction_comparison" => $transactionComparison
    );

} catch (Exception $e) {
    // Error response in case of an exception
    $response = array(
        "error" => true,
        "message" => "Error retrieving dashboard data: " . $e->getMessage(),
        "data" => array(
            "total_agents" => 0,
            "total_active_agents" => 0,
            "total_customers" => 0,
            "gender_breakdown" => array("Male" => 0, "Female" => 0),
            "total_balance" => 0,
            "average_balance" => 0,
            "charges_by_transaction" => array("Deposit" => 0, "Withdraw" => 0, "New Account" => 0, "New Loan" => 0),
            "transactions" => array(
                "today" => array("count" => 0, "total" => 0),
                "this_week" => array("count" => 0, "total" => 0),
                "this_month" => array("count" => 0, "total" => 0)
            ),
            "transaction_comparison" => array(
                "New Account" => array("count" => 0, "total_charges" => 0),
                "Deposit" => array("count" => 0, "total_charges" => 0),
                "Withdraw" => array("count" => 0, "total_charges" => 0),
                "New Loan" => array("count" => 0, "total_charges" => 0)
            )
        )
    );
}

// Output the JSON response
echo json_encode($response);

// Close the database connection
$connect->close();
?>
