<?php
require('config.php');

// Check if the necessary POST data is present
if (isset($_FILES['file']) && $_FILES['file']['error'] == UPLOAD_ERR_OK) {
    $uploadDir = 'images/';
    $uploadFile = $uploadDir . basename($_FILES['file']['name']);
    $userPhoto = basename($_FILES['file']['name']);

    // Ensure the upload directory exists
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    // Attempt to move the uploaded file to the specified directory
    if (move_uploaded_file($_FILES['file']['tmp_name'], $uploadFile)) {
        $response['error'] = false;
        $response['message'] = "File uploaded successfully";
        $response['file'] = $userPhoto;
    } else {
        $response['error'] = true;
        $response['message'] = "Failed to upload file";
    }
} else {
    $response['error'] = true;
    $response['message'] = "No file uploaded or file upload error";
}

// Output the response as JSON
echo json_encode($response);
?>
