<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

// Retrieve and decode the JSON data
$data = json_decode($_POST['customerData'], true);

// Initialize response array
$response = array("error" => false, "message" => "");

// Validate JSON data
if (empty($data) || !isset($data[0]['flag']) || !isset($data[0]['accNumber'])) {
    $response["error"] = true;
    $response["message"] = "Invalid data format or missing fields.";
    echo json_encode($response);
    exit;
}

// Assign values from decoded JSON data
$flag = $data[0]['flag'];
$account_number = mysqli_real_escape_string($connect, $data[0]['accNumber']);

// Check for the appropriate operation based on flag
if ($flag === "updateBalance") {
    // Ensure balance field is provided
    if (!isset($data[0]['balance'])) {
        $response["error"] = true;
        $response["message"] = "Balance is required for updating.";
        echo json_encode($response);
        exit;
    }

    // Sanitize balance data
    $account_balance = mysqli_real_escape_string($connect, $data[0]['balance']);

    // Construct the update query
    $query = "UPDATE customer_data SET ccount_balance = '$account_balance' WHERE account_number = '$account_number'";

    // Execute the query and handle errors
    if ($results = mysqli_query($connect, $query)) {
        if (mysqli_affected_rows($connect) > 0) {
            $response["message"] = "Account balance updated successfully.";
        } else {
            $response["error"] = true;
            $response["message"] = "No rows updated; the account number may not exist.";
        }
    } else {
        $response["error"] = true;
        $response["message"] = "Error executing update query: " . mysqli_error($connect);
    }

} elseif ($flag === "delete") {
    // Construct the delete query
    $query = "DELETE FROM customer_data WHERE account_number = '$account_number'";

    // Execute the delete query and handle errors
    if ($results = mysqli_query($connect, $query)) {
        if (mysqli_affected_rows($connect) > 0) {
            $response["message"] = "Account deleted successfully.";
        } else {
            $response["error"] = true;
            $response["message"] = "No rows deleted; the account number may not exist.";
        }
    } else {
        $response["error"] = true;
        $response["message"] = "Error executing delete query: " . mysqli_error($connect);
    }

} elseif ($flag === "updatePic") {
    // Check for filename field
    if (!isset($data[0]['filename'])) {
        $response["error"] = true;
        $response["message"] = "Filename is required for updating picture.";
        echo json_encode($response);
        exit;
    }

    // Sanitize filename data
    $filename = mysqli_real_escape_string($connect, $data[0]['filename']);

    // Update userPic in the database
    $query = "UPDATE customer_data SET userPic = '$filename' WHERE account_number = '$account_number'";

    // Execute the query and handle errors
    if ($result = mysqli_query($connect, $query)) {
        if (mysqli_affected_rows($connect) > 0) {
			$response["error"] = false;
            $response["message"] = "User picture updated successfully.";
        } else {
            $response["error"] = true;
            $response["message"] = "No rows updated; the account number may not exist.";
        }
    } else {
        $response["error"] = true;
        $response["message"] = "Error executing update query: " . mysqli_error($connect);
    }

} else {
    $response["error"] = true;
    $response["message"] = "Invalid operation flag.";
}

// Output the JSON response
echo json_encode($response);

// Close the database connection
$connect->close();
?>
