<?php
header("Content-Type: application/json"); // Set response header for JSON output
require('config.php'); // Database configuration file

// Initialize response array
$response = array("error" => false, "data" => array());

// Define months with their names
$months = [
    1 => "January", 2 => "February", 3 => "March",
    4 => "April", 5 => "May", 6 => "June",
    7 => "July", 8 => "August", 9 => "September",
    10 => "October", 11 => "November", 12 => "December"
];

$transactionTypes = array('deposit', 'withdraw', 'new account', 'loan payment', 'new loan');

// Query to retrieve transaction counts by year and month for each type
$query = "
    SELECT 
        YEAR(dateTime) AS year,
        MONTH(dateTime) AS month,
        transaction,
        COUNT(*) AS count
    FROM deposits
    WHERE transaction IN ('deposit', 'withdraw', 'new account', 'loan payment', 'new loan')
    GROUP BY year, month, transaction
    ORDER BY year DESC, month ASC, transaction
";

$result = mysqli_query($connect, $query);

if ($result) {
    // Temporary storage for organizing data
    $data = array();

    // Process each row from the query result
    while ($row = mysqli_fetch_assoc($result)) {
        $year = $row['year'];
        $month = $row['month'];
        $transactionType = $row['transaction'];
        $count = $row['count'];

        // Ensure the structure is organized by year with months as a list
        if (!isset($data[$year])) {
            $data[$year] = array();
        }

        // Check if the month already exists in the year, if not, initialize it
        $monthIndex = array_search($months[$month], array_column($data[$year], 'month'));
        if ($monthIndex === false) {
            $data[$year][] = array(
                "month" => $months[$month], // Use month name
                "deposit" => 0,
                "withdraw" => 0,
                "new account" => 0,
                "loan payment" => 0,
                "new loan" => 0
            );
            $monthIndex = count($data[$year]) - 1;
        }

        // Update the count for the specific transaction type in the month
        $data[$year][$monthIndex][$transactionType] = $count;
    }

    // Ensure all months and transaction types are present, even with zero values
    foreach ($data as $year => &$monthsData) {
        foreach ($months as $monthNum => $monthName) {
            $monthExists = array_search($monthName, array_column($monthsData, 'month'));
            if ($monthExists === false) {
                // If month is missing, add it with all transaction counts set to 0
                $monthsData[] = array(
                    "month" => $monthName,
                    "deposit" => 0,
                    "withdraw" => 0,
                    "new account" => 0,
                    "loan payment" => 0,
                    "new loan" => 0
                );
            }
        }

        // Sort the months in ascending order within each year
        usort($monthsData, function ($a, $b) use ($months) {
            return array_search($a['month'], $months) <=> array_search($b['month'], $months);
        });
    }

    // Convert the structured data into the desired JSON format
    foreach ($data as $year => $monthsData) {
        $response["data"][] = array(
            "year" => $year,
            "months" => $monthsData
        );
    }

    $response["message"] = "Transaction performance data retrieved successfully.";
} else {
    // Handle query execution errors
    $response["error"] = true;
    $response["message"] = "Error retrieving transaction data: " . mysqli_error($connect);
}

// Output the JSON response
echo json_encode($response);

// Close the database connection
$connect->close();
?>
