<?php
// TRANSACTION TABLE
require('config.php');

// Escape and sanitize POST data without ignoring "0" values
$ccount_balance = isset($_POST['ccount_balance']) ? mysqli_real_escape_string($connect, $_POST['ccount_balance']) : null;
$transaction = isset($_POST['transaction']) ? mysqli_real_escape_string($connect, $_POST['transaction']) : null;
$accountNumber = isset($_POST['acountNumber']) ? mysqli_real_escape_string($connect, $_POST['acountNumber']) : null;
$amount_Deposited = isset($_POST['amount_Diposited']) ? mysqli_real_escape_string($connect, $_POST['amount_Diposited']) : null;
$dateTime = isset($_POST['dateTime']) ? mysqli_real_escape_string($connect, $_POST['dateTime']) : null;
$operatingAgent = isset($_POST['operatingAgent']) ? mysqli_real_escape_string($connect, $_POST['operatingAgent']) : null;
$receipt_No = isset($_POST['receipt_No']) ? mysqli_real_escape_string($connect, $_POST['receipt_No']) : null;
$time = isset($_POST['time']) ? mysqli_real_escape_string($connect, $_POST['time']) : null;
$primaryAcc = isset($_POST['primaryAcc']) ? mysqli_real_escape_string($connect, $_POST['primaryAcc']) : null;
$newAccBalance = isset($_POST['newAccBalance']) ? mysqli_real_escape_string($connect, $_POST['newAccBalance']) : null;
$newLoanBalance = isset($_POST['newLoanBalance']) ? mysqli_real_escape_string($connect, $_POST['newLoanBalance']) : null;
$charges = isset($_POST['charges']) ? mysqli_real_escape_string($connect, $_POST['charges']) : null;
$balance_at_charge = isset($_POST['balance_at_charge']) ? mysqli_real_escape_string($connect, $_POST['balance_at_charge']) : null;

// Check if the receipt number is already used
$recieptNo = "SELECT * FROM deposits WHERE receipt_No = '$receipt_No' ORDER BY dateTime DESC";
$fetchRecieptNo = mysqli_query($connect, $recieptNo);

$statement = "Transaction Successful";
$failStatement = 'Receipt No. used.';
$db_data = array();

if ($fetchRecieptNo->num_rows > 0) {
    array_push($db_data, array('id' => $failStatement));
    echo json_encode($db_data);
} else {
    // Begin transaction
    mysqli_begin_transaction($connect);

    try {
        // Prepare the deposit query, ensuring all variables are checked with isset()
        if (isset($accountNumber, $amount_Deposited, $dateTime, $operatingAgent, $receipt_No, $time, $transaction, $charges, $balance_at_charge)) {
            // Insert into deposits table
            $stmt1 = $connect->prepare("INSERT INTO deposits (acountNumber, amount_Diposited, dateTime, operatingAgent, receipt_No, time, transaction, charges, balance_at_charge)
                                        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if ($stmt1) {
                $stmt1->bind_param("sssssssss", $accountNumber, $amount_Deposited, $dateTime, $operatingAgent, $receipt_No, $time, $transaction, $charges, $balance_at_charge);
                if (!$stmt1->execute()) {
                    throw new Exception('Error in deposits query: ' . mysqli_error($connect));
                }
            } else {
                throw new Exception('Error preparing deposits statement: ' . mysqli_error($connect));
            }

            // Insert into statistics table
            $stmt2 = $connect->prepare("INSERT INTO statistics (acountNumber, amount_Diposited, dateTime, operatingAgent, transaction, charges, balance_at_charge)
                                        VALUES (?, ?, ?, ?, ?, ?, ?)");
            if ($stmt2) {
                $stmt2->bind_param("sssssss", $accountNumber, $amount_Deposited, $dateTime, $operatingAgent, $transaction, $charges, $balance_at_charge);
                if (!$stmt2->execute()) {
                    throw new Exception('Error in statistics query: ' . mysqli_error($connect));
                }
            } else {
                throw new Exception('Error preparing statistics statement: ' . mysqli_error($connect));
            }
        }

        // Update customer data balance if not "New Account" and ccount_balance is set
        if ($transaction !== "New Account" && isset($ccount_balance)) {
            $stmt3 = $connect->prepare("UPDATE customer_data SET ccount_balance = ? WHERE account_number = ?");
            if ($stmt3) {
                $stmt3->bind_param("ss", $ccount_balance, $accountNumber);
                if (!$stmt3->execute()) {
                    throw new Exception('Error in customer_data update query: ' . mysqli_error($connect));
                }
            } else {
                throw new Exception('Error preparing customer_data statement: ' . mysqli_error($connect));
            }
        }

        // Update primary account balance if applicable and newAccBalance is set
        if (isset($primaryAcc, $newAccBalance)) {
            $stmt4 = $connect->prepare("UPDATE customer_data SET ccount_balance = ? WHERE account_number = ?");
            if ($stmt4) {
                $stmt4->bind_param("ss", $newAccBalance, $primaryAcc);
                if (!$stmt4->execute()) {
                    throw new Exception('Error in primary account update query: ' . mysqli_error($connect));
                }
            } else {
                throw new Exception('Error preparing primary account update statement: ' . mysqli_error($connect));
            }
        }

        // Update loan balance if applicable and newLoanBalance is set
        if (isset($primaryAcc, $newLoanBalance)) {
            $stmt5 = $connect->prepare("UPDATE loans SET loanBalance = ? WHERE primaryAcc = ?");
            if ($stmt5) {
                $stmt5->bind_param("ss", $newLoanBalance, $primaryAcc);
                if (!$stmt5->execute()) {
                    throw new Exception('Error in loan balance update query: ' . mysqli_error($connect));
                }
            } else {
                throw new Exception('Error preparing loan balance update statement: ' . mysqli_error($connect));
            }
        }

        // Commit transaction
        mysqli_commit($connect);

        array_push($db_data, array('id' => $statement));
        echo json_encode($db_data);

    } catch (Exception $e) {
        // Rollback transaction in case of error
        mysqli_rollback($connect);
        array_push($db_data, array('id' => "Transaction failed: " . $e->getMessage()));
        echo json_encode($db_data);
    }

    // Close statements if they were used
    if (isset($stmt1)) $stmt1->close();
    if (isset($stmt2)) $stmt2->close();
    if (isset($stmt3)) $stmt3->close();
    if (isset($stmt4)) $stmt4->close();
    if (isset($stmt5)) $stmt5->close();
}

$connect->close();
?>
