<?php
// Include database configuration
require('config.php');

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Initialize response
$response = [];

// Get releaseID from URL
$releaseID = isset($_GET['releaseID']) ? intval($_GET['releaseID']) : 0;

// Validate releaseID
if ($releaseID === 0) {
    $response = [
        'error' => true,
        'message' => 'Invalid or missing releaseID.',
    ];
    echo json_encode($response);
    exit();
}

// Prepare the SQL query to delete the release
$deleteQuery = "DELETE FROM releaseRecords WHERE id = ?";

// Prepare the statement
if ($stmt = mysqli_prepare($connect, $deleteQuery)) {
    // Bind the releaseID to the query
    mysqli_stmt_bind_param($stmt, "i", $releaseID);

    // Execute the query
    if (mysqli_stmt_execute($stmt)) {
        // Check if any row was affected
        if (mysqli_stmt_affected_rows($stmt) > 0) {
            $response = [
                'error' => false,
                'message' => 'Release successfully deleted.',
            ];
        } else {
            $response = [
                'error' => true,
                'message' => 'No release found with the given releaseID.',
            ];
        }
    } else {
        $response = [
            'error' => true,
            'message' => 'Failed to execute the delete query: ' . mysqli_error($connect),
        ];
    }

    // Close the statement
    mysqli_stmt_close($stmt);
} else {
    $response = [
        'error' => true,
        'message' => 'Failed to prepare the delete query: ' . mysqli_error($connect),
    ];
}

// Output the response as JSON
header('Content-Type: application/json');
echo json_encode($response);

// Close the database connection
mysqli_close($connect);
?>
