<?php
require('config.php');

try {
    // Query to fetch all values from the table
    $query = "SELECT * FROM system_dropdowns";
    $stmt = $connect->prepare($query);
    $stmt->execute();
    $result = $stmt->get_result();

    $dropdowns = [];

    while ($row = $result->fetch_assoc()) {
        // Ensure JSON format correction
        $correctedJson = str_replace("'", '"', $row['dorpdown']);
        $decodedValue = json_decode($correctedJson, true);
        
        // Fallback if decoding fails
        if ($decodedValue === null) {
            $decodedValue = explode(",", str_replace(["[", "]"], "", $row['dorpdown']));
        }
        
        $dropdowns[$row['title']] = array_map('trim', $decodedValue);
    }

    // Output JSON response
    echo json_encode(["error" => false, "data" => $dropdowns]);
} catch (Exception $e) {
    echo json_encode(["error" => true, "message" => $e->getMessage()]);
    exit();
}
?>