<?php
require('config.php');

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Initialize the response structure
$response = [
    "error" => false,
    "message" => "",
    "creditTransaction" => null // Initialize as null for a single transaction
];

if (isset($_POST['transID'])) {
    $transID = intval($_POST['transID']); // Ensure transID is an integer

    try {
        // Prepare the SQL query to retrieve credit transaction for the given transID
        $stmt = $connect->prepare("
            SELECT 
                credits.id AS creditID,
                credits.transID,
                credits.product,
                credits.date_taken,
                credits.reason,
                credits.source_of_fund,
                credits.taken_by,
                credits.title,
                credits.phone,
                credits.quantity AS creditQuantity,
                credits.status AS creditStatus,
                credits.served_by,
                credits.c_amount
            FROM credits
            WHERE credits.transID = ?
            LIMIT 1
        ");

        if (!$stmt) {
            throw new Exception("Failed to prepare statement: " . $connect->error);
        }

        // Bind the transID parameter
        $stmt->bind_param("i", $transID);

        // Execute the query
        if ($stmt->execute()) {
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // Fetch the single row and set it in the response
                $row = $result->fetch_assoc();
                $response['creditTransaction'] = [
                    "creditID" => $row["creditID"],
                    "transID" => $row["transID"],
                    "product" => $row["product"],
                    "date_taken" => $row["date_taken"],
                    "reason" => $row["reason"],
                    "source_of_fund" => $row["source_of_fund"],
                    "taken_by" => $row["taken_by"],
                    "title" => $row["title"],
                    "phone" => $row["phone"],
                    "creditQuantity" => $row["creditQuantity"],
                    "creditStatus" => $row["creditStatus"],
                    "served_by" => $row["served_by"],
                    "c_amount" => $row["c_amount"]
                ];
                $response['message'] = "Credit transaction retrieved successfully.";
            } else {
                $response['error'] = true;
                $response['message'] = "No credit transaction found for transID $transID.";
            }
        } else {
            throw new Exception("Failed to execute query: " . $stmt->error);
        }
    } catch (Exception $e) {
        $response['error'] = true;
        $response['message'] = "Exception occurred: " . $e->getMessage();
    }
} else {
    $response['error'] = true;
    $response['message'] = "Parameter 'transID' is required.";
}

// Output the response as JSON
echo json_encode($response);
?>
