<?php
require('config.php');

// Check if the necessary POST data is present
if (isset($_POST['stockData'])) {

    $stockData = $_POST['stockData'];

    // Decode the JSON data
    $stocksArray = json_decode($stockData, true);

    foreach ($stocksArray as $row) {
        // Prepare the SQL statement using parameterized queries to prevent SQL injection
        $stmt = $connect->prepare("INSERT INTO store_stock (productID, quantity, productPrice, store_price, size, addedBy, dateAdded) VALUES (?, ?, ?, ?, ?, ?, ?)");

        // Bind parameters to the SQL statement
        $stmt->bind_param(
            "iiiisis",
            $row["productID"],
            $row["quantity"],
            $row["productPrice"],
            $row["store_price"],
            $row["size"],
            $row["addedBy"],
            $row["dateAdded"]
        );

        // Execute the prepared statement
        $stmt->execute();
    }

    $response['error'] = false;
    $response['message'] = "Stock added successfully";
} else {
    $response['error'] = true;
    $response['message'] = "Insufficient parameters, please provide stock data.";
}

// Output the response as JSON
echo json_encode($response);
