<?php
require('config.php');

// Prepare response array
$response = ["error" => false, "message" => ""];

// Read JSON input
$inputJSON = file_get_contents('php://input');
$transData = json_decode($inputJSON, true);

if (is_array($transData) && count($transData) > 0) {
    // Prepare the insert query
    $insertQuery = "INSERT INTO tempShopList (id, productCode, quantity, amount, releaseDate, releaseType, servedBy, status, paymentMethod, referenceID) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    $stmt = $connect->prepare($insertQuery);

    try {
        foreach ($transData as $data) {
            // Bind parameters for each record
            $stmt->bind_param(
                "ssssssssss",
                $data['id'],
                $data['productCode'],
                $data['quantity'],
                $data['amount'],
                $data['releaseDate'],
                $data['releaseType'],
                $data['servedBy'],
                $data['status'],
                $data['paymentMethod'],
                $data['referenceID']
            );
            $stmt->execute();
        }

        $response["message"] = "Data inserted successfully.";
    } catch (Exception $e) {
        $response["error"] = true;
        $response["message"] = "Error inserting data: " . $e->getMessage();
    }
} else {
    $response["error"] = true;
    $response["message"] = "Invalid or empty input data.";
}

// Output response as JSON
echo json_encode($response);
?>
