<?php
require('config.php'); // Ensure database connection is included

// Check if all required parameters are provided
if (isset($_GET['storeStockID'], $_GET['userID'], $_GET['requestQTY'], $_GET['status'], $_GET['requestFrom'])) {
    // Sanitize input values
    $storeStockID = intval($_GET['storeStockID']);
    $userID = intval($_GET['userID']);
    $requestQTY = intval($_GET['requestQTY']);
    $status = $connect->real_escape_string($_GET['status']);
    $requestFrom = $connect->real_escape_string($_GET['requestFrom']);
    $timeStamp = $connect->real_escape_string($_GET['timeStamp']);

    // Insert query
    $query = "INSERT INTO stock_requests (storeStockID, userID, requestQTY, status, requestFrom,timeStamp) VALUES (?, ?, ?, ?, ?, ?)";

    // Prepare the statement
    if ($stmt = $connect->prepare($query)) {
        $stmt->bind_param("iiisss", $storeStockID, $userID, $requestQTY, $status, $requestFrom, $timeStamp);

        // Execute the statement
        if ($stmt->execute()) {
            $response = [
                "error" => false,
                "message" => "Stock request inserted successfully.",
                "requestID" => $stmt->insert_id
            ];
        } else {
            $response = [
                "error" => true,
                "message" => "Error inserting stock request: " . $stmt->error
            ];
        }

        // Close the statement
        $stmt->close();
    } else {
        $response = [
            "error" => true,
            "message" => "Database query preparation failed."
        ];
    }
} else {
    $response = [
        "error" => true,
        "message" => "Missing required parameters."
    ];
}

// Output the response as JSON
echo json_encode($response);

?>
